<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldsToCompanyProfiles extends Migration
{
    public function up()
    {
        Schema::table('company_profiles', function (Blueprint $table) {
            if (!Schema::hasColumn('company_profiles', 'first_name')) {
                $table->string('first_name', 100)->nullable()->after('User_id');
            }
            if (!Schema::hasColumn('company_profiles', 'last_name')) {
                $table->string('last_name', 100)->nullable()->after('first_name');
            }
            if (!Schema::hasColumn('company_profiles', 'postal_code')) {
                $table->string('postal_code', 10)->nullable()->after('Location');
            }
            if (!Schema::hasColumn('company_profiles', 'type_of_care_needed')) {
                $table->longText('type_of_care_needed')->nullable()->after('family_details');
            }
            if (!Schema::hasColumn('company_profiles', 'availability_needs')) {
                $table->longText('availability_needs')->nullable()->after('type_of_care_needed');
            }
            if (!Schema::hasColumn('company_profiles', 'special_needs')) {
                $table->text('special_needs')->nullable()->after('availability_needs');
            }
        });
    }

    public function down()
    {
        Schema::table('company_profiles', function (Blueprint $table) {
            $table->dropColumn([
                'first_name',
                'last_name',
                'postal_code',
                'type_of_care_needed',
                'availability_needs',
                'special_needs'
            ]);
        });
    }
}
